package com.isn 
{
	import com.adobe.images.BMPEncoder;
	import com.adobe.images.JPGEncoder;
	import com.adobe.images.PNGEncoder;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import org.bytearray.gif.encoder.GIFEncoder;
	
	/**
	 * ...
	 * @author Richard GAUTHIER
	 * Professeur au Lycee Paul Serusier
	 * 29270 Carhaix
	 */
	public class BitMapIsn extends Bitmap 
	{   private var conteneur : Loader; 
		
		public function BitMapIsn() 
		{
			
		}
		
		/****************************************************************
		 * Transforme un objet graphique en bitmap (Sprite,video,...)
		 * @param	myObjet	L'objet graphique.
		 *******************************************************/
		public function objetGraphic(myObjet:*):void 
		{
			this.bitmapData = new BitmapData(myObjet.width,myObjet.height);
			this.bitmapData.draw(myObjet);
			
		}
		
		/****************************************************************
		 * Load files SWF, JPEG, GIF, or PNG.
		 * @param	urlImage The URL to be requested. You can set the URL later by using the url property.
		 *******************************************************/
		public function loadImage(urlImage:String):void 
		{var adresseImage :URLRequest = new URLRequest(urlImage);
			conteneur = new Loader();
		conteneur.contentLoaderInfo.addEventListener(Event.COMPLETE, imageCharger);
			conteneur.load(adresseImage);
		}
		
		private function imageCharger(e:Event):void 
		{
			this.bitmapData = new BitmapData(conteneur.width,conteneur.height);
			this.bitmapData.draw(conteneur);
			conteneur.contentLoaderInfo.removeEventListener(Event.COMPLETE, imageCharger);
			conteneur = null;
		}
		
		
		/****************************************************************
		 * Retourne la valeur du rouge d'un Pixel
		 * @param	x	The x position of the pixel.
		 * @param	y	The y position of the pixel.
		 * @return	A number that represents an Red pixel value. If the (x, y) coordinates are 
		 *   outside the bounds of the image, the method returns 0.
		 *******************************************************/
		public function getRed(x:int , y:int):uint {
			var myPixel : uint;
			try 
			{
			myPixel = this.bitmapData.getPixel(x, y);
			myPixel = myPixel / 256 / 256;
			
			}catch (e:Error) {
			myPixel = 0;
			}
				return myPixel
			}
		
		/****************************************************************
		 * Retourne la valeur du vert d'un Pixel
		 * @param	x	The x position of the pixel.
		 * @param	y	The y position of the pixel.
		 * @return	A number that represents an Green pixel value. If the (x, y) coordinates are 
		 *   outside the bounds of the image, the method returns 0.
		 *******************************************************/
		public function getGreen(x:int , y:int):uint {
			var myPixel : uint;
			myPixel = this.bitmapData.getPixel(x, y);
			myPixel = myPixel / 256;
			var valeur : uint = myPixel / 256;
			myPixel = myPixel - valeur * 256 ;
			return myPixel;
		}
		
		/****************************************************************
		 * Retourne la valeur du bleu d'un Pixel
		 * @param	x	The x position of the pixel.
		 * @param	y	The y position of the pixel.
		 * @return	A number that represents an Red pixel value. If the (x, y) coordinates are 
		 *   outside the bounds of the image, the method returns 0.
		 *******************************************************/
		public function getBlue(x:int , y:int):uint {
			var myPixel : uint;
			myPixel = this.bitmapData.getPixel(x, y);
			var valeur : uint = myPixel / 256;
			myPixel = myPixel - valeur * 256 ;
			return myPixel;
		}
		
		/****************************************************************
		 * Change la valeur du rouge d'un Pixel
		 * @param	x	The x position of the pixel whose value changes.
		 * @param	y	The y position of the pixel whose value changes.
		 * @param	colorRed	Change la valeur du rouge du pixel (0 à 255).
		 *******************************************************/
		public function setRed( x:int, y:int, colorRed:uint) : void {
			var myPixel : uint;
			myPixel = colorRed * 256 * 256 + getGreen(x, y) * 256 + getBlue(x, y);  
			this.bitmapData.setPixel(x,y,myPixel);
		}
		
		/****************************************************************
		 * Change la valeur du vert d'un Pixel
		 * @param	x	The x position of the pixel whose value changes.
		 * @param	y	The y position of the pixel whose value changes.
		 * @param	colorGreen	Change la valeur du vert du pixel (0 à 255).
		 *******************************************************/
		public function setGreen( x:int, y:int, colorGreen:uint) : void {
			var myPixel : uint;
			myPixel = getRed(x, y) * 256 * 256 + colorGreen * 256 + getBlue(x, y);  
			this.bitmapData.setPixel(x,y,myPixel);
		}
		
		/****************************************************************
		 * Change la valeur du bleu d'un Pixel
		 * @param	x	The x position of the pixel whose value changes.
		 * @param	y	The y position of the pixel whose value changes.
		 * @param	colorBlue	Change la valeur du bleu du pixel (0 à 255).
		 *******************************************************/
		public function setBlue( x:int, y:int, colorBlue:uint) : void {
			var myPixel : uint;
			myPixel = getRed(x, y) * 256 * 256 + getGreen(x, y) * 256 + colorBlue;  
			this.bitmapData.setPixel(x,y,myPixel);
		}
		
		
		/****************************************************************
		 * Sauvegarde une image au format JPEG
		 * @param filename Le nom du fichier.
		 * @param quality The quality level between 1 and 100 that detrmines the
		 * level of compression used in the generated JPEG
		 *******************************************************/
		public function saveJPEG(filename:String,quality : Number = 50):void {
		
			filename = filename + ".jpg";
			
			// use adobe’s encoder to create a byteArray
            var jpgEncoder:JPGEncoder = new JPGEncoder(quality);
            var byteArray:ByteArray = jpgEncoder.encode(this.bitmapData);
            
			copierImage(filename, byteArray);
			byteArray = null;
			
			}
		
		/****************************************************************
		 * Sauvegarde une image au format PNG
		 * @param filename Le nom du fichier.
		 *******************************************************/
		public function savePNG(filename:String):void {
		    
            filename = filename + ".png";
			
			var byteArray:ByteArray = PNGEncoder.encode(this.bitmapData);
            
			copierImage(filename, byteArray);
			byteArray = null;
			
			}
			
		/****************************************************************
		 * Sauvegarde une image au format BMP
		 * @param filename Le nom du fichier.
		 *******************************************************/
		public function saveBMP(filename:String):void {
		    
            filename = filename + ".bmp";
			
			var byteArray:ByteArray = BMPEncoder.encode(this.bitmapData);
            
			copierImage(filename, byteArray);
			byteArray = null;
			}
		
		/****************************************************************
		 * Sauvegarde une image au format GIF
		 * @param filename Le nom du fichier.
		 *******************************************************/
		public function saveGIF(filename:String):void {
		    
            filename = filename + ".gif";
			
		   var encoder:GIFEncoder = new GIFEncoder();
                        
           encoder.setRepeat(0);                   //AUTO LOOP
           encoder.setDelay(500);
                        
           encoder.start();                        //MUST HAVE!
                        
           encoder.addFrame(this.bitmapData);
                        
           encoder.finish();                       //MUST HAVE!
         
		   copierImage(filename, encoder.stream);
		   encoder = null;
		}
		
			
		/****************************************************************
		 * Sauvegarde du fichier image
		 *******************************************************/
		 private function copierImage(filename : String , byteArray : ByteArray):void {
			
			// recupere le repertoire mesDocument
            var file:File = File.documentsDirectory.resolvePath( filename );
            // get the native path 
            var wr:File = new File( file.nativePath );
            // create filestream 
            var stream:FileStream = new FileStream();
            //  open/create the file, set the filemode to write; because we are going to save
            stream.open( wr , FileMode.WRITE);
            // write your byteArray into the file. 
            stream.writeBytes ( byteArray, 0, byteArray.length );
            // close the file. That’s it.
            stream.close();
				
				
			}
		
	}

}